/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.compras.valores.ModeloValoresFormaPago;
import ec.gob.sri.dimm.ats.modelo.obj.compras.FormaPago;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class PaginaOperacion<T extends ObjetoModelo>
extends PaginaAsistente
implements VistaModelo<T>,
VistaValoresPropios {
    protected ModeloValoresFormaPago modeloValores;
    protected FormaPago formaAgregar;
    protected FormaPago formaSeleccionada;
    private Table table;
    protected ComboViewer cvForma;
    protected TableViewer tvFormasDePago;
    protected Button btnEliminar;
    protected Button btnNewButton;
    protected boolean esNotaCredito;
    private String labelColumna = "Formas de Pago";
    private final Periodo periodo;

    protected PaginaOperacion(String nombrePagina, String titulo, String descripcion, Periodo periodo) {
        super(nombrePagina, titulo, descripcion);
        this.periodo = periodo;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(4, false));
        Label lblFomasDePago = new Label(container, 0);
        GridData gd_lblFomasDePago = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblFomasDePago.widthHint = 100;
        lblFomasDePago.setLayoutData((Object)gd_lblFomasDePago);
        lblFomasDePago.setText(this.labelColumna);
        this.cvForma = new ComboViewer(container, 8);
        this.cvForma.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor formaPago = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (formaPago != null) {
                    PaginaOperacion.this.formaAgregar = new FormaPago();
                    PaginaOperacion.this.formaAgregar.setTipoFormaPago((String)formaPago.getValor());
                    PaginaOperacion.this.formaAgregar.setDescripcionTipoFormaPago(formaPago.getNombre());
                }
            }
        });
        Combo combo = this.cvForma.getCombo();
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 200;
        combo.setLayoutData((Object)gd_combo);
        this.btnEliminar = new Button(container, 0);
        GridData gd_btnEliminar = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnEliminar.widthHint = 40;
        this.btnEliminar.setLayoutData((Object)gd_btnEliminar);
        this.btnEliminar.setText("+");
        Label lblNewLabel = new Label(container, 0);
        GridData gd_lblNewLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel.widthHint = 200;
        lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        new Label(container, 0);
        this.tvFormasDePago = new TableViewer(container, 67584);
        this.tvFormasDePago.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaOperacion.this.formaSeleccionada = (FormaPago)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
            }
        });
        this.table = this.tvFormasDePago.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(16384, 4, true, true, 1, 1));
        TableColumn tblclmnFormasDePago = new TableColumn(this.table, 0);
        tblclmnFormasDePago.setWidth(200);
        tblclmnFormasDePago.setText(this.labelColumna);
        this.btnNewButton = new Button(container, 0);
        GridData gd_btnNewButton = new GridData(16384, 128, false, false, 1, 1);
        gd_btnNewButton.widthHint = 40;
        this.btnNewButton.setLayoutData((Object)gd_btnNewButton);
        this.btnNewButton.setText("-");
        new Label(container, 0);
        this.procesarModeloDatos();
        this.btnAgregarClicked();
        this.btnEliminarClicked();
    }

    protected abstract void btnAgregarClicked();

    protected abstract void btnEliminarClicked();

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresFormaPago(this.periodo.getFechaDeclarada());
        this.modeloValores.inicializar();
    }

    public void setLabelColumna(String labelColumna) {
        this.labelColumna = labelColumna;
    }

    public void procesarModeloDatos() {
    }

    public void refrescarControles() {
        if (this.cvForma != null) {
            this.cvForma.refresh();
            this.tvFormasDePago.refresh();
        }
    }
}

